@extends('admin.layout.master')

@section('body')
    <div class="row">
        <div class="col-md">
            <div class="card">
                <div class="card-header bg-white font-weight-bold ">
                    <h2>{{$page_title}}</h2>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                            <tr>
                                <th scope="col">@lang('SL')</th>
                                <th scope="col">@lang('TRX')</th>
                                <th scope="col">@lang('Withdraw Amount')</th>
                                <th scope="col">@lang('Charge')</th>
                                <th scope="col">@lang('Method')</th>
                                <th scope="col">@lang('Receive Amount')</th>
                                <th scope="col">@lang('Status')</th>
                                <th scope="col">@lang('Time')</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($withdrawLog as $k=>$data)
                                <tr>
                                    <td data-label="@lang('SL')">{{++$k}}</td>
                                    <td data-label="#@lang('TRX')">{{$data->trx }}</td>
                                    <td data-label="@lang('Withdraw Amount')">{{$data->withdraw_amount }} {{$basic->currency}}</td>

                                    <td data-label="@lang('Charge')">
                                        <i class="icofont-money"></i>
                                        <span class="strong">{!! number_format($data->charge, $basic->decimal) !!}</span>
                                        <span class="base-color strong">{{$basic->currency}}</span>
                                    </td>


                                    <td data-label="@lang('Method')">{{$data->method->name }}</td>

                                    <td data-label="@lang('Receive Amount')">
                                        <i class="icofont-money"></i>
                                        <span class="strong"> {{number_format($data->receive_currency_amount, $basic->decimal) }} </span>
                                        <span class="base-color strong">{{$data->method->name }}</span>
                                    </td>
                                    <td data-label="@lang('Status')">
                                        @if($data->status == 1)
                                            <span class="badge badge-primary"> @lang('Pending') </span>
                                        @elseif($data->status == 2)
                                            <span class="badge badge-success"> @lang('Approved') </span>
                                        @elseif($data->status == -2)
                                            <span class="badge badge-danger"> @lang('Refunded')</span>
                                        @endif
                                    </td>
                                    <td data-label="@lang('Time')">
                                        {!! date(' d M,Y h:i A', strtotime($data->created_at)) !!}</td>
                                </tr>
                            @endforeach
                            <tbody>
                        </table>

                        {!! $withdrawLog->links() !!}
                    </div>
                </div>
            </div>
        </div>

@endsection